/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.deploy.heroku;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.PlatformUtil;
import com.aptana.deploy.heroku.HerokuPlugin;
import com.aptana.deploy.heroku.Messages;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import org.eclipse.core.internal.preferences.Base64;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

public class HerokuAPI {
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String USER_AGENT = "User-Agent";
    private static final String ACCEPT_HEADER = "Accept";
    private static final String ACCEPT_CONTENT_TYPES = "application/xml, application/json";
    private static final String HEROKU_API_VERSION_HEADER = "X-Heroku-API-Version";
    private static final String API_VERSION_NUMBER = "2";
    private String userId;
    private String password;

    public HerokuAPI(String userId, String password) {
        this.userId = userId;
        this.password = password;
    }

    public static File getCredentialsFile() {
        String filepath = PlatformUtil.expandEnvironmentStrings((String)("~" + File.separator + ".heroku" + File.separator + "credentials"));
        return new File(filepath);
    }

    public IStatus authenticate() {
        HttpURLConnection connection = null;
        try {
            URL url = new URL("https://api.heroku.com/apps");
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestProperty(USER_AGENT, "Aptana Studio 3.0.0");
            connection.setRequestProperty(HEROKU_API_VERSION_HEADER, API_VERSION_NUMBER);
            connection.setRequestProperty(ACCEPT_HEADER, ACCEPT_CONTENT_TYPES);
            connection.setUseCaches(false);
            connection.setAllowUserInteraction(false);
            String usernamePassword = String.valueOf(this.userId) + ":" + this.password;
            connection.setRequestProperty(AUTHORIZATION_HEADER, "Basic " + new String(Base64.encode((byte[])usernamePassword.getBytes())));
            int code = connection.getResponseCode();
            if (code == 200) {
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            if (code == 401 || code == 403) {
                Status status = new Status(4, HerokuPlugin.getPluginIdentifier(), Messages.HerokuAPI_AuthFailed_Error);
                return status;
            }
            Status status = new Status(4, HerokuPlugin.getPluginIdentifier(), Messages.HerokuAPI_AuthConnectionFailed_Error);
            return status;
        }
        catch (Exception e) {
            Status status = new Status(4, HerokuPlugin.getPluginIdentifier(), e.getMessage(), (Throwable)e);
            return status;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    /*
     * Loose catch block
     */
    public boolean writeCredentials() {
        File credentials = HerokuAPI.getCredentialsFile();
        credentials.getParentFile().mkdirs();
        BufferedWriter writer = null;
        writer = new BufferedWriter(new FileWriter(credentials));
        writer.write(this.userId);
        writer.newLine();
        writer.write(this.password);
        try {
            if (writer != null) {
                writer.close();
            }
        }
        catch (IOException iOException) {}
        return true;
        catch (IOException e) {
            try {
                IdeLog.logError((Plugin)HerokuPlugin.getDefault(), (Throwable)e);
            }
            catch (Throwable throwable) {
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException iOException) {}
        }
        return false;
    }

    /*
     * Loose catch block
     */
    public static HerokuAPI fromCredentials() {
        File file = HerokuAPI.getCredentialsFile();
        BufferedReader reader = null;
        reader = new BufferedReader(new FileReader(file));
        String userId = reader.readLine();
        String password = reader.readLine();
        HerokuAPI herokuAPI = new HerokuAPI(userId, password);
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException iOException) {}
        return herokuAPI;
        catch (Exception e) {
            try {
                IdeLog.logError((Plugin)HerokuPlugin.getDefault(), (Throwable)e);
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
        return new HerokuAPI(null, null){

            @Override
            public IStatus authenticate() {
                return new Status(4, HerokuPlugin.getPluginIdentifier(), Messages.HerokuAPI_UnableToGetHerokuCredentialsError);
            }

            @Override
            public boolean writeCredentials() {
                return false;
            }
        };
    }
}

